﻿using Percent___Qualification_work.Classes;
using Percent___Qualification_work.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Text;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Percent___Qualification_work.userControls
{
    public partial class mList : UserControl
    {
        private List<DataRow> moviesList = new List<DataRow>();
        private int currentPage = 1;
        private const int moviesPerPage = 10;
        public mList()
        {
            InitializeComponent();
        }
        public void LoadMovies()
        {
            
            DataTable moviesTable = DatabaseConnection.Instance.GetUserMovies(Authentication.ActiveUserID);
            moviesList = moviesTable.AsEnumerable().ToList();
            DisplayMovies();
        }

        private void DisplayMovies()
        {
            flowLayoutPanel1.Controls.Clear();

            int startIndex = (currentPage - 1) * moviesPerPage;
            int endIndex = Math.Min(startIndex + moviesPerPage, moviesList.Count);
            
            for(int i = startIndex; i < endIndex; i++)
            {
                DataRow movie = moviesList[i];
                Panel movieCard = CreateMovieCard(movie);
                flowLayoutPanel1.Controls.Add(movieCard);
            }
            UpdatePaginator();
        }

        private Panel CreateMovieCard(DataRow movie)
        {
            Panel card = new Panel
            {
                BorderStyle = BorderStyle.FixedSingle,
                Size = new Size(120, 158),
                Margin = new Padding(5),
                Cursor = Cursors.Hand // Change cursor to indicate clickability
            };

            PictureBox pictureBox = new PictureBox
            {
                SizeMode = PictureBoxSizeMode.StretchImage,
                Size = new Size(120, 120),
                Location = new Point(0, 0)
            };

            if (movie["CoverImage"] is byte[] imageData)
            {
                pictureBox.Image = ConvertBytesToImage(imageData);
            }

            Label nameLabel = new Label
            {
                Text = movie["MovieName"].ToString(),
                Font = new Font("Arial", 8, FontStyle.Bold),
                AutoSize = false,
                TextAlign = ContentAlignment.MiddleCenter,
                Size = new Size(120, 30),
                Location = new Point(0, 125)
            };

            card.Controls.Add(pictureBox);
            card.Controls.Add(nameLabel);
            card.MouseClick += (s, e) => ShowGameDialog(movie);
            pictureBox.MouseClick += (s, e) => ShowGameDialog(movie);
            nameLabel.MouseClick += (s, e) => ShowGameDialog(movie);
            return card;
        }

        private void UpdatePaginator()
        {

            prevButton.Enabled = currentPage > 1;
            nextButton.Enabled = currentPage * moviesPerPage < moviesList.Count;
            pageLabel.Text = $"Page {currentPage} of {Math.Ceiling((double)moviesList.Count / moviesPerPage)}";
        }

        private void prevButton_Click(object sender, EventArgs e)
        {
            if (currentPage > 1)
            {
                currentPage--;
                DisplayMovies();
            }
        }

        private void nextButton_Click(object sender, EventArgs e)
        {
            if (currentPage * moviesPerPage < moviesList.Count)
            {
                currentPage++;
                DisplayMovies();
            }
        }

        private Image ConvertBytesToImage(byte[] imageData)
        {
            using (var ms = new System.IO.MemoryStream(imageData))
            {
                return Image.FromStream(ms);
            }
        }

        private void ShowGameDialog(DataRow movie)
        {
            using (MovieDetailsDialog dialog = new MovieDetailsDialog(movie))
            {
                dialog.RefreshMovies += LoadMovies;
                dialog.ShowDialog();
            }
        }
    }
}
